; I-Imagine Xbox Bone Shader
;
; Author: Dan Wagner
;
; v0 = position x,y,z
; v1 = blending weights bw1 (bw2 is calculated as 1.0f - bw1)
; v2 = bone index (4 bytes packed) this shader only uses index x & y (2 bones per vert)
; v3 = normal nx, ny, nz
; v4 = texture coordinates tu, tv
;
; c[-96]..c[84] = bone matricies (max = 60)
; c[88]..c[91] = concatanated world, view, projection matrix
; c[92] = light direction
; c[93] = ambient color value
; c[94] = diffuse color value
; c[95] = 0.0f, 1.0f, -1.0f, 0.0f

xvs.1.1

def c95, 0.0f, 1.0f, -1.0f, 0.0f

;get index for bone 1
mov a0.x, v2.x

;transform position for bone 1 
m4x3 r0, v0, c[a0.x - 96] ;into local bone space (with animation)
mov r0.w, v0.w			  ;w remains unchanged

;transform normal for bone 1 
m3x3 r7, v3, c[a0.x - 96] ;into local bone space (with animation)
mov r7.w, c95.y

;multiply by bw1 (blending weight 1)
mul r1, r0, v1.x ;position
mul r7, r7, v1.x ;normal

;get index for bone 2
mov a0.x, v2.y

;transform position for bone 2
m4x3 r2, v0, c[a0.x - 96] ;into local bone space (with animation)
mov r2.w, v0.w			  ;w remains unchanged

;transform normal for bone 2 
m3x3 r9, v3, c[a0.x - 96] ;into local bone space (with animation)
mov r9.w, c95.y

;calculate the 2nd blending weight
mad r4.x, c95.z, v1.x, c95.x

;multiply by bw2 (blending weight 2)
mad r3, r2, r4.x, r1
m4x4 oPos, r3, c88
mad r10, r9, r4.x, r7    ;normal

;normalize the blended normal
dp3 r10.w, r10, r10
rsq r10.w, r10.w
mul r10, r10, r10.w

;dot the vert normal with the light direction
dp3 r10.x, r10, c92
max r10.x, r10.x, c95.x       ;if dot < 0 then dot = 0

;calculate intensity by multiplying with diffuse
mul oD0, r10.x, c94

;add the ambient color and store in output register
;add oD0, c93, r10.x

;Compute fog factor (fogVal = sqrt(dot(pos, pos)) 
dp3 r5.w, r12, r12
rsq r6.w, r5.w
mul oFog.x, r5.w, r6.w

;move the texture coordinate to the texture output register
mov oT0, v4

dp4 oT3.x, r3, c84
dp4 oT3.y, r3, c85
dp4 oT3.z, r3, c86
dp4 r0.w, r3, c87

;clamp w (q) to 0
slt r1, c88, c88
max r0.w, r0.w, r1.w
mov oT3.w, r0.w
